(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     58689,       1228]*)
(*NotebookOutlinePosition[     59343,       1251]*)
(*  CellTagsIndexPosition[     59299,       1247]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(f[x_] = 1.6 - 600/975  x^2\)], "Input"],

Cell[BoxData[
    \(\(\(1.6`\)\(\[InvisibleSpace]\)\) - \(8\ x\^2\)\/13\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(A = 
      Plot[f[x], {x, \(-2.3\), 1}, PlotPoints \[Rule] 50, 
        AspectRatio \[Rule] 1.3\/GoldenRatio, Ticks \[Rule] None, 
        PlotStyle \[Rule] {Thickness[0.004]}, 
        AxesStyle -> {Thickness[0.002]}, AxesOrigin \[Rule] {\(-2.1\), 0}, 
        PlotRange \[Rule] {\(-0.3\), 2}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .80344 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.68759 0.2886 0.104797 0.349324 [
[ -0.001 -0.001 0 0 ]
[ 1.001 .80444 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.002 w
[ ] 0 setdash
0 .1048 m
1 .1048 L
s
.08153 0 m
.08153 .80344 L
s
0 0 m
1 0 L
1 .80344 L
0 .80344 L
closepath
clip
newpath
.004 w
.18049 0 m
.199 .0476 L
.21902 .09705 L
.23829 .14271 L
.25683 .1848 L
.27656 .22767 L
.29555 .26703 L
.31574 .30684 L
.33519 .3432 L
.3539 .37632 L
.3738 .40959 L
.39297 .43968 L
.41334 .46959 L
.43296 .49638 L
.45184 .52027 L
.47193 .54367 L
.49127 .56424 L
.50987 .58219 L
.52967 .59934 L
.54872 .61394 L
.56898 .62741 L
.5885 .63837 L
.60727 .64706 L
.62725 .65432 L
.63717 .65715 L
.64648 .65935 L
.65538 .66104 L
.66497 .66239 L
.66966 .66288 L
.67478 .66329 L
.67737 .66345 L
.67879 .66352 L
.68014 .66357 L
.68139 .66362 L
.68275 .66365 L
.68398 .66368 L
.68512 .6637 L
.68573 .66371 L
.68631 .66371 L
.68684 .66371 L
.68741 .66371 L
.68803 .66371 L
.68837 .66371 L
.68868 .66371 L
.68929 .66371 L
.68987 .6637 L
.69041 .66369 L
.69098 .66369 L
.692 .66366 L
.6931 .66364 L
Mistroke
.69431 .6636 L
.69684 .66349 L
.69954 .66335 L
.70442 .66298 L
.70941 .66249 L
.71484 .6618 L
.7247 .66016 L
.73441 .65806 L
.7447 .6553 L
.76322 .64895 L
.78293 .64025 L
.80191 .62998 L
.82209 .61703 L
.84152 .60256 L
.86021 .58681 L
.8801 .56806 L
.89925 .54809 L
.9196 .52478 L
.93921 .50031 L
.95808 .47488 L
.97619 .44875 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 231.375},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X00018AP00`40o`000?l0003oooooofWoool0
01goool00`000?ooooooo`0Qoooo00<0003oooooool0ooooobGoool001goool00`000?ooooooo`0Q
oooo00<0003oooooool0ooooobGoool001goool00`000?ooooooo`0Roooo00<0003oooooool0oooo
obCoool001goool00`000?ooooooo`0Roooo00<0003oooooool0ooooobCoool001goool00`000?oo
ooooo`0Roooo00<0003oooooool0ooooobCoool001goool00`000?ooooooo`0Soooo00<0003ooooo
ool0ooooob?oool001goool00`000?ooooooo`0Soooo00<0003oooooool0ooooob?oool001goool0
0`000?ooooooo`0Soooo00<0003oooooool0ooooob?oool001goool00`000?ooooooo`0Toooo00<0
003oooooool0ooooob;oool001goool00`000?ooooooo`0Toooo00<0003oooooool0ooooob;oool0
01goool00`000?ooooooo`0Uoooo00<0003oooooool0ooooob7oool001goool00`000?ooooooo`0U
oooo00<0003oooooool0ooooob7oool001goool00`000?ooooooo`0Uoooo00<0003oooooool0oooo
ob7oool001goool00`000?ooooooo`0Voooo00<0003oooooool0ooooob3oool001goool00`000?oo
ooooo`0Voooo00<0003oooooool0ooooob3oool001goool00`000?ooooooo`0Voooo00<0003ooooo
ool0ooooob3oool001goool00`000?ooooooo`0Woooo00<0003oooooool0oooooaooool001goool0
0`000?ooooooo`0Woooo00<0003oooooool0oooooaooool001goool00`000?ooooooo`0Woooo00<0
003oooooool0oooooaooool001goool00`000?ooooooo`0Xoooo00<0003oooooool0oooooakoool0
01goool00`000?ooooooo`0Xoooo00<0003oooooool0oooooakoool001goool00`000?ooooooo`0Y
oooo00<0003oooooool0oooooagoool001goool00`000?ooooooo`0Yoooo00<0003oooooool0oooo
oagoool001goool00`000?ooooooo`0Yoooo00<0003oooooool0oooooagoool001goool00`000?oo
ooooo`0Zoooo00<0003oooooool0oooooacoool001goool00`000?ooooooo`0Zoooo00<0003ooooo
ool0oooooacoool001goool00`000?ooooooo`0[oooo00<0003oooooool0oooooa_oool001goool0
0`000?ooooooo`0[oooo00<0003oooooool0oooooa_oool001goool00`000?ooooooo`0/oooo00<0
003oooooool0oooooa[oool001goool00`000?ooooooo`0/oooo00<0003oooooool0oooooa[oool0
01goool00`000?ooooooo`0/oooo00<0003oooooool0oooooa[oool001goool00`000?ooooooo`0]
oooo00<0003oooooool0oooooaWoool001goool00`000?ooooooo`0]oooo00<0003oooooool0oooo
oaWoool001goool00`000?ooooooo`0^oooo00<0003oooooool0oooooaSoool001goool00`000?oo
ooooo`0^oooo00<0003oooooool0oooooaSoool001goool00`000?ooooooo`0^oooo00<0003ooooo
ool0oooooaSoool001goool00`000?ooooooo`0_oooo00<0003oooooool0oooooaOoool00?l0001X
00000Oooo`007Oooo`030000oooooooo033oool00`000?ooooooo`3ooooo5_ooo`007Oooo`030000
oooooooo033oool00`000?ooooooo`3ooooo5_ooo`007Oooo`030000oooooooo033oool00`000?oo
ooooo`3ooooo5_ooo`007Oooo`030000oooooooo037oool00`000?ooooooo`3ooooo5Oooo`007Ooo
o`030000oooooooo037oool00`000?ooooooo`3ooooo5Oooo`007Oooo`030000oooooooo03;oool0
0`000?ooooooo`3ooooo5?ooo`007Oooo`030000oooooooo03;oool00`000?ooooooo`3ooooo5?oo
o`007Oooo`030000oooooooo03?oool00`000?ooooooo`3ooooo4oooo`007Oooo`030000oooooooo
03?oool00`000?ooooooo`3ooooo4oooo`007Oooo`030000oooooooo03?oool00`000?ooooooo`3o
oooo4oooo`007Oooo`030000oooooooo03Coool00`000?ooooooo`3ooooo4_ooo`007Oooo`030000
oooooooo03Coool00`000?ooooooo`3ooooo4_ooo`007Oooo`030000oooooooo03Goool00`000?oo
ooooo`3ooooo4Oooo`007Oooo`030000oooooooo03Goool00`000?ooooooo`3ooooo4Oooo`007Ooo
o`030000oooooooo03Goool00`000?ooooooo`3ooooo4Oooo`007Oooo`030000oooooooo03Koool0
0`000?ooooooo`3ooooo4?ooo`007Oooo`030000oooooooo03Koool00`000?ooooooo`3ooooo4?oo
o`007Oooo`030000oooooooo03Ooool00`000?ooooooo`3ooooo3oooo`007Oooo`030000oooooooo
03Ooool00`000?ooooooo`3ooooo3oooo`007Oooo`030000oooooooo03Soool00`000?ooooooo`3o
oooo3_ooo`007Oooo`030000oooooooo03Soool00`000?ooooooo`3ooooo3_ooo`007Oooo`030000
oooooooo03Woool00`000?ooooooo`3ooooo3Oooo`007Oooo`030000oooooooo03Woool00`000?oo
ooooo`3ooooo3Oooo`007Oooo`030000oooooooo03[oool00`000?ooooooo`3ooooo3?ooo`007Ooo
o`030000oooooooo03[oool00`000?ooooooo`3ooooo3?ooo`007Oooo`030000oooooooo03_oool0
0`000?ooooooo`3ooooo2oooo`007Oooo`030000oooooooo03_oool00`000?ooooooo`3ooooo2ooo
o`007Oooo`030000oooooooo03coool00`000?ooooooo`3ooooo2_ooo`007Oooo`030000oooooooo
03coool00`000?ooooooo`3ooooo2_ooo`007Oooo`030000oooooooo03coool00`000?ooooooo`3o
oooo2_ooo`007Oooo`030000oooooooo03goool00`000?ooooooo`3ooooo2Oooo`007Oooo`030000
oooooooo03goool00`000?ooooooo`3ooooo2Oooo`007Oooo`030000oooooooo03koool00`000?oo
ooooo`3ooooo2?ooo`007Oooo`030000oooooooo03koool00`000?ooooooo`3ooooo2?ooo`007Ooo
o`030000oooooooo03ooool00`000?ooooooo`3ooooo1oooo`007Oooo`030000oooooooo03ooool0
0`000?ooooooo`3ooooo1oooo`007Oooo`030000oooooooo043oool00`000?ooooooo`3ooooo1_oo
o`007Oooo`030000oooooooo043oool00`000?ooooooo`3ooooo1_ooo`007Oooo`030000oooooooo
047oool00`000?ooooooo`3ooooo1Oooo`007Oooo`030000oooooooo047oool00`000?ooooooo`3o
oooo1Oooo`007Oooo`030000oooooooo04;oool00`000?ooooooo`3ooooo1?ooo`007Oooo`030000
oooooooo04;oool00`000?ooooooo`3ooooo1?ooo`007Oooo`030000oooooooo04?oool00`000?oo
ooooo`3ooooo0oooo`007Oooo`030000oooooooo04?oool00`000?ooooooo`3ooooo0oooo`007Ooo
o`030000oooooooo04Coool00`000?ooooooo`3ooooo0_ooo`007Oooo`030000oooooooo04Coool0
0`000?ooooooo`3ooooo0_ooo`007Oooo`030000oooooooo04Goool00`000?ooooooo`3ooooo0Ooo
o`007Oooo`030000oooooooo04Goool00`000?ooooooo`3ooooo0Oooo`007Oooo`030000oooooooo
04Koool00`000?ooooooo`3ooooo000Moooo00<0003oooooool0A_ooo`030000oooooooo0?ooool0
01goool00`000?ooooooo`17oooo00<0003oooooool0o_ooo`007Oooo`030000oooooooo04Ooool0
0`000?ooooooo`3noooo000Moooo00<0003oooooool0B?ooo`030000oooooooo0?goool001goool0
0`000?ooooooo`18oooo00<0003oooooool0oOooo`007Oooo`030000oooooooo04Woool00`000?oo
ooooo`3loooo000Moooo00<0003oooooool0BOooo`030000oooooooo0?coool001goool00`000?oo
ooooo`1:oooo00<0003oooooool0noooo`007Oooo`030000oooooooo04[oool00`000?ooooooo`3k
oooo000Moooo00<0003oooooool0Boooo`030000oooooooo0?[oool001goool00`000?ooooooo`1;
oooo00<0003oooooool0n_ooo`007Oooo`030000oooooooo04coool00`000?ooooooo`3ioooo000M
oooo00<0003oooooool0C?ooo`030000oooooooo0?Woool001goool00`000?ooooooo`1=oooo00<0
003oooooool0n?ooo`007Oooo`030000oooooooo04goool00`000?ooooooo`3hoooo000Moooo00<0
003oooooool0C_ooo`030000oooooooo0?Ooool001goool00`000?ooooooo`1>oooo00<0003ooooo
ool0moooo`007Oooo`030000oooooooo04ooool00`000?ooooooo`3foooo000Moooo00<0003ooooo
ool0Coooo`030000oooooooo0?Koool001goool00`000?ooooooo`1@oooo00<0003oooooool0mOoo
o`007Oooo`030000oooooooo053oool00`000?ooooooo`3eoooo000Moooo00<0003oooooool0DOoo
o`030000oooooooo0?Coool001goool00`000?ooooooo`1Aoooo00<0003oooooool0m?ooo`007Ooo
o`030000oooooooo05;oool00`000?ooooooo`3coooo000Moooo00<0003oooooool0D_ooo`030000
oooooooo0??oool001goool00`000?ooooooo`1Coooo00<0003oooooool0l_ooo`007Oooo`030000
oooooooo05?oool00`000?ooooooo`3boooo000Moooo00<0003oooooool0E?ooo`030000oooooooo
0?7oool001goool00`000?ooooooo`1Doooo00<0003oooooool0lOooo`007Oooo`030000oooooooo
05Goool00`000?ooooooo`3`oooo000Moooo00<0003oooooool0EOooo`030000oooooooo0?3oool0
01goool00`000?ooooooo`1Foooo00<0003oooooool0koooo`007Oooo`030000oooooooo05Koool0
0`000?ooooooo`3_oooo000Moooo00<0003oooooool0Eoooo`030000oooooooo0>koool001goool0
0`000?ooooooo`1Goooo00<0003oooooool0k_ooo`007Oooo`030000oooooooo05Soool00`000?oo
ooooo`3]oooo000Moooo00<0003oooooool0FOooo`030000oooooooo0>coool001goool00`000?oo
ooooo`1Ioooo00<0003oooooool0k?ooo`007Oooo`030000oooooooo05[oool00`000?ooooooo`3[
oooo000Moooo00<0003oooooool0F_ooo`030000oooooooo0>_oool001goool00`000?ooooooo`1K
oooo00<0003oooooool0j_ooo`007Oooo`030000oooooooo05_oool00`000?ooooooo`3Zoooo000M
oooo00<0003oooooool0G?ooo`030000oooooooo0>Woool001goool00`000?ooooooo`1Moooo00<0
003oooooool0j?ooo`007Oooo`030000oooooooo05goool00`000?ooooooo`3Xoooo000Moooo00<0
003oooooool0G_ooo`030000oooooooo0>Ooool001goool00`000?ooooooo`1Noooo00<0003ooooo
ool0ioooo`007Oooo`030000oooooooo05ooool00`000?ooooooo`3Voooo000Moooo00<0003ooooo
ool0H?ooo`030000oooooooo0>Goool001goool00`000?ooooooo`1Poooo00<0003oooooool0iOoo
o`007Oooo`030000oooooooo067oool00`000?ooooooo`3Toooo000Moooo00<0003oooooool0HOoo
o`030000oooooooo0>Coool001goool00`000?ooooooo`1Roooo00<0003oooooool0hoooo`007Ooo
o`030000oooooooo06;oool00`000?ooooooo`3Soooo000Moooo00<0003oooooool0Hoooo`030000
oooooooo0>;oool001goool00`000?ooooooo`1Toooo00<0003oooooool0hOooo`007Oooo`030000
oooooooo06Coool00`000?ooooooo`3Qoooo000Moooo00<0003oooooool0IOooo`030000oooooooo
0>3oool001goool00`000?ooooooo`1Uoooo00<0003oooooool0h?ooo`007Oooo`030000oooooooo
06Koool00`000?ooooooo`3Ooooo000Moooo00<0003oooooool0Ioooo`030000oooooooo0=koool0
01goool00`000?ooooooo`1Woooo00<0003oooooool0g_ooo`007Oooo`030000oooooooo06Soool0
0`000?ooooooo`3Moooo000Moooo00<0003oooooool0JOooo`030000oooooooo0=coool001goool0
0`000?ooooooo`1Yoooo00<0003oooooool0g?ooo`007Oooo`030000oooooooo06[oool00`000?oo
ooooo`3Koooo000Moooo00<0003oooooool0J_ooo`030000oooooooo0=_oool001goool00`000?oo
ooooo`1[oooo00<0003oooooool0f_ooo`007Oooo`030000oooooooo06coool00`000?ooooooo`3I
oooo000Moooo00<0003oooooool0K?ooo`030000oooooooo0=Woool001goool00`000?ooooooo`1]
oooo00<0003oooooool0f?ooo`007Oooo`030000oooooooo06koool00`000?ooooooo`3Goooo000M
oooo00<0003oooooool0K_ooo`030000oooooooo0=Ooool001goool00`000?ooooooo`1_oooo00<0
003oooooool0boooo`030000oooooooo00Soool001goool00`000?ooooooo`1`oooo00<0003ooooo
ool0bOooo`030000oooooooo00Woool001goool00`000?ooooooo`1`oooo00<0003oooooool0bOoo
o`030000oooooooo00Woool001goool00`000?ooooooo`1aoooo00<0003oooooool0aoooo`030000
oooooooo00[oool001goool00`000?ooooooo`1aoooo00<0003oooooool0aoooo`030000oooooooo
00[oool001goool00`000?ooooooo`1boooo00<0003oooooool0aOooo`030000oooooooo00_oool0
01goool00`000?ooooooo`1coooo00<0003oooooool0`oooo`030000oooooooo00coool001goool0
0`000?ooooooo`1coooo00<0003oooooool0`oooo`030000oooooooo00coool001goool00`000?oo
ooooo`1doooo00<0003oooooool0`Oooo`030000oooooooo00goool001goool00`000?ooooooo`1e
oooo00<0003oooooool0`?ooo`030000oooooooo00goool001goool00`000?ooooooo`1foooo00<0
003oooooool0__ooo`030000oooooooo00koool001goool00`000?ooooooo`1foooo00<0003ooooo
ool0_Oooo`030000oooooooo00ooool001goool00`000?ooooooo`1goooo00<0003oooooool0^ooo
o`030000oooooooo013oool001goool00`000?ooooooo`1hoooo00<0003oooooool0^_ooo`030000
oooooooo013oool001goool00`000?ooooooo`1ioooo00<0003oooooool0^?ooo`030000oooooooo
017oool001goool00`000?ooooooo`1ioooo00<0003oooooool0]oooo`030000oooooooo01;oool0
01goool00`000?ooooooo`1joooo00<0003oooooool0]Oooo`030000oooooooo01?oool001goool0
0`000?ooooooo`1koooo00<0003oooooool0]?ooo`030000oooooooo01?oool001goool00`000?oo
ooooo`1loooo00<0003oooooool0/_ooo`030000oooooooo01Coool001goool00`000?ooooooo`1m
oooo00<0003oooooool0/?ooo`030000oooooooo01Goool001goool00`000?ooooooo`1moooo00<0
003oooooool0[oooo`030000oooooooo01Koool001goool00`000?ooooooo`1noooo00<0003ooooo
ool0[Oooo`030000oooooooo01Ooool001goool00`000?ooooooo`1ooooo00<0003oooooool0Zooo
o`030000oooooooo01Soool001goool00`000?ooooooo`20oooo00<0003oooooool0Z_ooo`030000
oooooooo01Soool001goool00`000?ooooooo`20oooo00<0003oooooool0ZOooo`030000oooooooo
01Woool001goool00`000?ooooooo`21oooo00<0003oooooool0Yoooo`030000oooooooo01[oool0
01goool00`000?ooooooo`22oooo00<0003oooooool0YOooo`030000oooooooo01_oool001goool0
0`000?ooooooo`23oooo00<0003oooooool0Xoooo`030000oooooooo01coool001goool00`000?oo
ooooo`24oooo00<0003oooooool0XOooo`030000oooooooo01goool001goool00`000?ooooooo`25
oooo00<0003oooooool0Woooo`030000oooooooo01koool001goool00`000?ooooooo`26oooo00<0
003oooooool0W_ooo`030000oooooooo01koool001goool00`000?ooooooo`26oooo00<0003ooooo
ool0WOooo`030000oooooooo01ooool001goool00`000?ooooooo`27oooo00<0003oooooool0Vooo
o`030000oooooooo023oool001goool00`000?ooooooo`28oooo00<0003oooooool0VOooo`030000
oooooooo027oool001goool00`000?ooooooo`29oooo00<0003oooooool0V?ooo`030000oooooooo
027oool001goool00`000?ooooooo`2:oooo00<0003oooooool0U_ooo`030000oooooooo02;oool0
01goool00`000?ooooooo`2;oooo00<0003oooooool0U?ooo`030000oooooooo02?oool001goool0
0`000?ooooooo`2<oooo00<0003oooooool0T_ooo`030000oooooooo02Coool001goool00`000?oo
ooooo`2=oooo00<0003oooooool0T?ooo`030000oooooooo02Goool001goool00`000?ooooooo`2=
oooo00<0003oooooool0Soooo`030000oooooooo02Koool001goool00`000?ooooooo`2>oooo00<0
003oooooool0SOooo`030000oooooooo02Ooool001goool00`000?ooooooo`2?oooo00<0003ooooo
ool0Roooo`030000oooooooo02Soool001goool00`000?ooooooo`2@oooo00<0003oooooool0ROoo
o`030000oooooooo02Woool001goool00`000?ooooooo`2Aoooo00<0003oooooool0Qoooo`030000
oooooooo02[oool001goool00`000?ooooooo`2Boooo00<0003oooooool0QOooo`030000oooooooo
02_oool001goool00`000?ooooooo`2Coooo0P0008Coool00`000?ooooooo`0/oooo000Moooo00<0
003oooooool0UOooo`030000oooooooo083oool00`000?ooooooo`0]oooo000Moooo00<0003ooooo
ool0U_ooo`030000oooooooo07koool00`000?ooooooo`0^oooo000Moooo00<0003oooooool0Uooo
o`030000oooooooo07coool00`000?ooooooo`0_oooo000Moooo00<0003oooooool0V?ooo`030000
oooooooo07[oool00`000?ooooooo`0`oooo000Moooo00<0003oooooool0VOooo`030000oooooooo
07Soool00`000?ooooooo`0aoooo000Moooo00<0003oooooool0V_ooo`80001foooo0P0003Coool0
01goool00`000?ooooooo`2Loooo00<0003oooooool0L_ooo`030000oooooooo03Coool001goool0
0`000?ooooooo`2Moooo00<0003oooooool0L?ooo`030000oooooooo03Goool001goool00`000?oo
ooooo`2Noooo00<0003oooooool0KOooo`80000hoooo000Moooo00<0003oooooool0Woooo`030000
oooooooo06_oool00`000?ooooooo`0hoooo000Moooo00<0003oooooool0X?ooo`80001Yoooo0P00
03_oool001goool00`000?ooooooo`2Roooo00<0003oooooool0IOooo`030000oooooooo03_oool0
01goool00`000?ooooooo`2Soooo00<0003oooooool0Hoooo`030000oooooooo03coool001goool0
0`000?ooooooo`2Toooo00<0003oooooool0H?ooo`80000ooooo000Moooo00<0003oooooool0YOoo
o`80001Ooooo00<0003oooooool0?oooo`007Oooo`030000oooooooo0:Ooool00`000?ooooooo`1J
oooo0P0004;oool001goool00`000?ooooooo`2Xoooo0P0005Woool00`000?ooooooo`12oooo000M
oooo00<0003oooooool0Z_ooo`80001Foooo00<0003oooooool0@oooo`007Oooo`030000oooooooo
0:coool00`000?ooooooo`1Aoooo0P0004Koool001goool00`000?ooooooo`2]oooo0P00053oool0
0`000?ooooooo`16oooo000Moooo00<0003oooooool0[oooo`80001<oooo0P0004Woool001goool0
0`000?ooooooo`2aoooo0P0004Soool20000Boooo`007Oooo`030000oooooooo0;?oool20000A?oo
o`80001=oooo000Moooo00<0003oooooool0]Oooo`800010oooo0P0004ooool001goool00`000?oo
ooooo`2goooo0P0003coool20000DOooo`007Oooo`030000oooooooo0;Woool20000>?ooo`80001C
oooo000Moooo00<0003oooooool0^oooo`80000coooo0`0005Goool001goool00`000?ooooooo`2m
oooo0`0002goool30000F?ooo`007Oooo`030000oooooooo0<3oool300009_ooo`@0001Koooo000M
oooo00<0003oooooool0`oooo`<0000Ooooo100005ooool001goool00`000?ooooooo`36oooo1`00
01;oool60000Hoooo`007Oooo`030000oooooooo0<gooolB0000JOooo`007Oooo`030000oooooooo
0?oooom9oooo000Moooo00<0003oooooool0ooooodWoool001goool00`000?ooooooo`3oooooBOoo
o`007Oooo`030000oooooooo0?oooom9oooo000Moooo00<0003oooooool0ooooodWoool001goool0
0`000?ooooooo`3oooooBOooo`007Oooo`030000oooooooo0?oooom9oooo000Moooo00<0003ooooo
ool0ooooodWoool001goool00`000?ooooooo`3oooooBOooo`007Oooo`030000oooooooo0?oooom9
oooo000Moooo00<0003oooooool0ooooodWoool001goool00`000?ooooooo`3oooooBOooo`007Ooo
o`030000oooooooo0?oooom9oooo000Moooo00<0003oooooool0ooooodWoool001goool00`000?oo
ooooo`3oooooBOooo`007Oooo`030000oooooooo0?oooom9oooo000Moooo00<0003oooooool0oooo
odWoool001goool00`000?ooooooo`3oooooBOooo`007Oooo`030000oooooooo0?oooom9oooo000M
oooo00<0003oooooool0ooooodWoool001goool00`000?ooooooo`3oooooBOooo`007Oooo`030000
oooooooo0?oooom9oooo000Moooo00<0003oooooool0ooooodWoool001goool00`000?ooooooo`3o
ooooBOooo`007Oooo`030000oooooooo0?oooom9oooo000Moooo00<0003oooooool0ooooodWoool0
01goool00`000?ooooooo`3oooooBOooo`007Oooo`030000oooooooo0?oooom9oooo000Moooo00<0
003oooooool0ooooodWoool001goool00`000?ooooooo`3oooooBOooo`007Oooo`030000oooooooo
0?oooom9oooo000Moooo00<0003oooooool0ooooodWoool001goool00`000?ooooooo`3oooooBOoo
o`007Oooo`030000oooooooo0?oooom9oooo000Moooo00<0003oooooool0ooooodWoool001goool0
0`000?ooooooo`3oooooBOooo`007Oooo`030000oooooooo0?oooom9oooo000Moooo00<0003ooooo
ool0ooooodWoool001goool00`000?ooooooo`3oooooBOooo`007Oooo`030000oooooooo0?oooom9
oooo000Moooo00<0003oooooool0ooooodWoool001goool00`000?ooooooo`3oooooBOooo`007Ooo
o`030000oooooooo0?oooom9oooo000Moooo00<0003oooooool0ooooodWoool001goool00`000?oo
ooooo`3oooooBOooo`007Oooo`030000oooooooo0?oooom9oooo000Moooo00<0003oooooool0oooo
odWoool001goool00`000?ooooooo`3oooooBOooo`007Oooo`030000oooooooo0?oooom9oooo000M
oooo00<0003oooooool0ooooodWoool00001\
\>"],
  ImageRangeCache->{{{0, 359}, {288.188, 0}} -> {-2.38832, -0.302874, \
0.0121053, 0.010001}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(B = {Line[{{\(-1.2\), f[\(-1.2\)]}, {0.7, f[0.7]}}], 
        Line[{{\(-1.2\), f[\(-1.2\)]}, {\(-1.2\), 0}}], 
        Line[{{0.7, f[0.7]}, {0.7, 0}}], 
        Line[{{\(-1.2\), f[\(-1.2\)]}, {0.7, f[\(-1.2\)]}}], {Dashing[{0.025, 
              0.018}], Line[{{d, f[d]}, {d, 0}}]}, 
        Line[{{\(-1.4\), f[d] - \((1200/975)\) d \((\(-1.4\) - d)\)}, {0.9, 
              f[d] - \((1200/975)\) d \((0.9 - d)\)}}], 
        Circle[{\(-1.2\), f[\(-1.2\)]},  .4, {0, 
            ArcTan[\((f[0.7] - f[\(-1.2\)])\)/1.9]}], 
        Text[a1, {\(-1.2\), \(-0.1\)}], Text[a2, {0.7, \(-0.15\)}], 
        Text[a3, {\(-2\), f[\(-1.2\)]}], Text[a4, {0.85, f[0.7]}], 
        Text[a5, {d, \(-0.1\)}], 
        Text[a6, {\((\(-1.1\) + d)\)/2, f[\(-1.2\)] + 0.065}], 
        Text[a7, {0.9, f[\(-1.3\)]}], Text[a8, {d - 0.7, f[d] + 0.07}], 
        Text[a9, {0.5, 1.7}]}\)], "Input"],

Cell[BoxData[
    \({Line[{{\(-1.2`\), 0.713846153846154`}, {0.7`, 1.2984615384615386`}}], 
      Line[{{\(-1.2`\), 0.713846153846154`}, {\(-1.2`\), 0}}], 
      Line[{{0.7`, 1.2984615384615386`}, {0.7`, 0}}], 
      Line[{{\(-1.2`\), 0.713846153846154`}, {0.7`, 
            0.713846153846154`}}], {Dashing[{0.025`, 0.018`}], 
        Line[{{\(-0.24999999999999997`\), 
              1.5615384615384615`}, {\(-0.24999999999999997`\), 0}}]}, 
      Line[{{\(-1.4`\), 1.2076923076923078`}, {0.9`, 1.9153846153846152`}}], 
      Circle[{\(-1.2`\), 0.713846153846154`}, 
        0.4`, {0, 0.29849893158617924`}], Text[a1, {\(-1.2`\), \(-0.1`\)}], 
      Text[a2, {0.7`, \(-0.15`\)}], Text[a3, {\(-2\), 0.713846153846154`}], 
      Text[a4, {0.85`, 1.2984615384615386`}], 
      Text[a5, {\(-0.24999999999999997`\), \(-0.1`\)}], 
      Text[a6, {\(-0.675`\), 0.778846153846154`}], Text[a7, {0.9`, 0.56`}], 
      Text[a8, {\(-0.95`\), 1.6315384615384616`}], 
      Text[a9, {0.5`, 1.7`}]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(d = \(-975\)/1200 \((\((f[0.7] - f[\(-1.2\)])\)/1.9)\)\)], "Input"],

Cell[BoxData[
    \(\(-0.24999999999999997`\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[A, Graphics[B]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .80344 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.68759 0.2886 0.104797 0.349324 [
[ -0.001 -0.001 0 0 ]
[ 1.001 .80444 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.002 w
[ ] 0 setdash
0 .1048 m
1 .1048 L
s
.08153 0 m
.08153 .80344 L
s
0 0 m
1 0 L
1 .80344 L
0 .80344 L
closepath
clip
newpath
.004 w
.18049 0 m
.199 .0476 L
.21902 .09705 L
.23829 .14271 L
.25683 .1848 L
.27656 .22767 L
.29555 .26703 L
.31574 .30684 L
.33519 .3432 L
.3539 .37632 L
.3738 .40959 L
.39297 .43968 L
.41334 .46959 L
.43296 .49638 L
.45184 .52027 L
.47193 .54367 L
.49127 .56424 L
.50987 .58219 L
.52967 .59934 L
.54872 .61394 L
.56898 .62741 L
.5885 .63837 L
.60727 .64706 L
.62725 .65432 L
.63717 .65715 L
.64648 .65935 L
.65538 .66104 L
.66497 .66239 L
.66966 .66288 L
.67478 .66329 L
.67737 .66345 L
.67879 .66352 L
.68014 .66357 L
.68139 .66362 L
.68275 .66365 L
.68398 .66368 L
.68512 .6637 L
.68573 .66371 L
.68631 .66371 L
.68684 .66371 L
.68741 .66371 L
.68803 .66371 L
.68837 .66371 L
.68868 .66371 L
.68929 .66371 L
.68987 .6637 L
.69041 .66369 L
.69098 .66369 L
.692 .66366 L
.6931 .66364 L
Mistroke
.69431 .6636 L
.69684 .66349 L
.69954 .66335 L
.70442 .66298 L
.70941 .66249 L
.71484 .6618 L
.7247 .66016 L
.73441 .65806 L
.7447 .6553 L
.76322 .64895 L
.78293 .64025 L
.80191 .62998 L
.82209 .61703 L
.84152 .60256 L
.86021 .58681 L
.8801 .56806 L
.89925 .54809 L
.9196 .52478 L
.93921 .50031 L
.95808 .47488 L
.97619 .44875 L
Mfstroke
.5 Mabswid
.34127 .35416 m
.88961 .55838 L
s
.34127 .35416 m
.34127 .1048 L
s
.88961 .55838 m
.88961 .1048 L
s
.34127 .35416 m
.88961 .35416 L
s
[ .025 .018 ] 0 setdash
.61544 .65028 m
.61544 .1048 L
s
[ ] 0 setdash
.28355 .52667 m
.94733 .77389 L
s
newpath
matrix currentmatrix
0.11544 0.139729 scale
2.95625 2.53461 1 0 17.1027 arc
setmatrix s
gsave
.34127 .06986 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a1) show
1.000 setlinewidth
grestore
gsave
.88961 .0524 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a2) show
1.000 setlinewidth
grestore
gsave
.11039 .35416 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a3) show
1.000 setlinewidth
grestore
gsave
.9329 .55838 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a4) show
1.000 setlinewidth
grestore
gsave
.61544 .06986 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a5) show
1.000 setlinewidth
grestore
gsave
.49278 .37687 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a6) show
1.000 setlinewidth
grestore
gsave
.94733 .30042 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a7) show
1.000 setlinewidth
grestore
gsave
.41342 .67473 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a8) show
1.000 setlinewidth
grestore
gsave
.83189 .69865 -69 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a9) show
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 231.375},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005X00018AP00`40o`000?l0003oooooofWoool0
01goool00`000?ooooooo`0Qoooo00<0003oooooool0ooooobGoool001goool00`000?ooooooo`0Q
oooo00<0003oooooool0ooooobGoool001goool00`000?ooooooo`0Roooo00<0003oooooool0oooo
obCoool001goool00`000?ooooooo`0Roooo00<0003oooooool0ooooobCoool001goool00`000?oo
ooooo`0Roooo00<0003oooooool0ooooobCoool001goool00`000?ooooooo`0Soooo00<0003ooooo
ool0ooooob?oool001goool00`000?ooooooo`0Soooo00<0003oooooool0ooooob?oool001goool0
0`000?ooooooo`0Soooo00<0003oooooool0ooooob?oool001goool00`000?ooooooo`0Toooo00<0
003oooooool0ooooob;oool001goool00`000?ooooooo`0Toooo00<0003oooooool0ooooob;oool0
01goool00`000?ooooooo`0Uoooo00<0003oooooool0ooooob7oool001goool00`000?ooooooo`0U
oooo00<0003oooooool0ooooob7oool001goool00`000?ooooooo`0Uoooo00<0003oooooool0oooo
ob7oool001goool00`000?ooooooo`0Voooo00<0003oooooool0ooooob3oool001goool00`000?oo
ooooo`0Voooo00<0003oooooool0ooooob3oool001goool00`000?ooooooo`0Voooo00<0003ooooo
ool0ooooob3oool001goool00`000?ooooooo`0Woooo00<0003oooooool0koooo`<000001?ooo`00
00000?ooo`D0000Soooo000Moooo00<0003oooooool09oooo`030000oooooooo0>koool010000?oo
ooooooooo`800002oooo00D0003oooooooooool000008oooo`007Oooo`030000oooooooo02Ooool0
0`000?ooooooo`3^oooo00<0003oooooool00_ooo`050000oooooooooooo000002Koool001goool0
0`000?ooooooo`0Xoooo00<0003oooooool0k_ooo`D00004oooo00<0003oooooool08oooo`007Ooo
o`030000oooooooo02Soool00`000?ooooooo`3]oooo00<0003oooooool00_ooo`030000oooooooo
00?oool00`000?ooooooo`0Roooo000Moooo00<0003oooooool0:Oooo`030000oooooooo0>goool4
00001oooo`030000oooooooo027oool001goool00`000?ooooooo`0Yoooo00<0003oooooool0:Ooo
o`<000000oooo`0000000002oooo1@0005Goool3000000?oool0000000000_ooo`@0001Moooo00D0
003oooooooooool000008oooo`007Oooo`030000oooooooo02Woool00`000?ooooooo`0Xoooo00@0
003oooooooooool200001Oooo`030000oooooooo05Coool010000?ooooooooooo`800002oooo00<0
003oooooool00_ooo`030000oooooooo05_oool300009?ooo`007Oooo`030000oooooooo02[oool0
0`000?ooooooo`0Woooo00<0003oooooool00_ooo`030000oooooooo00?oool00`000?ooooooo`1D
oooo00<0003oooooool00_ooo`030000oooooooo00Goool00`000?ooooooo`22oooo000Moooo00<0
003oooooool0:_ooo`030000oooooooo02Soool500001Oooo`030000oooooooo05Goool500001ooo
o`030000oooooooo08;oool001goool00`000?ooooooo`0[oooo00<0003oooooool09_ooo`030000
oooooooo00;oool00`000?ooooooo`03oooo00<0003oooooool0E?ooo`030000oooooooo00;oool0
10000?ooooooooooo`@00025oooo000Moooo00<0003oooooool0:oooo`030000oooooooo02Ooool4
00001_ooo`030000oooooooo05Goool400001?ooo`030000oooooooo08Koool001goool00`000?oo
ooooo`0/oooo00<0003oooooool0;_ooo`<0001Ooooo00<0003oooooool0Q_ooo`007Oooo`030000
oooooooo02coool00`000?ooooooo`0`oooo00<0003oooooool0GOooo`D00024oooo000Moooo00<0
003oooooool0;?ooo`030000oooooooo0?oooolJoooo000Moooo00<0003oooooool0;Oooo`030000
oooooooo0?oooolIoooo000Moooo00<0003oooooool0;Oooo`030000oooooooo0?oooolIoooo000M
oooo00<0003oooooool0;_ooo`030000oooooooo0?oooolHoooo000Moooo00<0003oooooool0;_oo
o`030000oooooooo0?oooolHoooo000Moooo00<0003oooooool0;_ooo`030000oooooooo0?oooolH
oooo000Moooo00<0003oooooool0;oooo`030000oooooooo0?oooolGoooo003o0000J000007oool0
01goool00`000?ooooooo`0`oooo00<0003oooooool09oooo`030000oooooooo0<7oool00`000?oo
ooooo`0Woooo000Moooo00<0003oooooool0<?ooo`030000oooooooo02Ooool00`000?ooooooo`1O
oooo00<0003oooooool0Goooo`030000oooooooo02Ooool001goool00`000?ooooooo`0`oooo00<0
003oooooool09oooo`030000oooooooo05ooool00`000?ooooooo`1Ooooo00<0003oooooool09ooo
o`007Oooo`030000oooooooo037oool00`000?ooooooo`0Voooo00<0003oooooool0Goooo`030000
oooooooo05ooool00`000?ooooooo`0Woooo000Moooo00<0003oooooool0<Oooo`030000oooooooo
02Koool00`000?ooooooo`1Ooooo00<0003oooooool0Goooo`030000oooooooo02Ooool001goool0
0`000?ooooooo`0boooo00<0003oooooool09Oooo`030000oooooooo05ooool00`000?ooooooo`1O
oooo00<0003oooooool09oooo`007Oooo`030000oooooooo03;oool00`000?ooooooo`0Uoooo00<0
003oooooool0Goooo`030000oooooooo05ooool00`000?ooooooo`0Woooo000Moooo00<0003ooooo
ool0<oooo`030000oooooooo02Coool00`000?ooooooo`1Ooooo00<0003oooooool0Goooo`030000
oooooooo02Ooool001goool00`000?ooooooo`0coooo00<0003oooooool09?ooo`030000oooooooo
05ooool00`000?ooooooo`1Ooooo00<0003oooooool09oooo`007Oooo`030000oooooooo03?oool0
0`000?ooooooo`0Toooo00<0003oooooool0Goooo`030000oooooooo05ooool00`000?ooooooo`0W
oooo000Moooo00<0003oooooool0=?ooo`030000oooooooo02?oool00`000?ooooooo`1Ooooo00<0
003oooooool0Goooo`030000oooooooo02Ooool001goool00`000?ooooooo`0doooo00<0003ooooo
ool08oooo`030000oooooooo0<7oool00`000?ooooooo`0Woooo000Moooo00<0003oooooool0=Ooo
o`030000oooooooo02;oool00`000?ooooooo`31oooo00<0003oooooool09oooo`007Oooo`030000
oooooooo03Goool00`000?ooooooo`0Roooo00<0003oooooool0`Oooo`030000oooooooo02Ooool0
01goool00`000?ooooooo`0eoooo00<0003oooooool08_ooo`030000oooooooo0<7oool00`000?oo
ooooo`0Woooo000Moooo00<0003oooooool0=_ooo`030000oooooooo027oool00`000?ooooooo`31
oooo00<0003oooooool09oooo`007Oooo`030000oooooooo03Koool00`000?ooooooo`0Qoooo00<0
003oooooool0Goooo`030000oooooooo05ooool00`000?ooooooo`0Woooo000Moooo00<0003ooooo
ool0=oooo`030000oooooooo023oool00`000?ooooooo`1Ooooo00<0003oooooool0Goooo`030000
oooooooo02Ooool001goool00`000?ooooooo`0goooo00<0003oooooool08?ooo`030000oooooooo
05ooool00`000?ooooooo`1Ooooo00<0003oooooool09oooo`007Oooo`030000oooooooo03Soool0
0`000?ooooooo`0Ooooo00<0003oooooool0Goooo`030000oooooooo05ooool00`000?ooooooo`0W
oooo000Moooo00<0003oooooool0>?ooo`030000oooooooo01ooool00`000?ooooooo`1Ooooo00<0
003oooooool0Goooo`030000oooooooo02Ooool001goool00`000?ooooooo`0ioooo00<0003ooooo
ool07_ooo`030000oooooooo05ooool00`000?ooooooo`1Ooooo00<0003oooooool09oooo`007Ooo
o`030000oooooooo03Woool00`000?ooooooo`0Noooo00<0003oooooool0Goooo`030000oooooooo
05ooool00`000?ooooooo`0Woooo000Moooo00<0003oooooool0>_ooo`030000oooooooo01goool0
0`000?ooooooo`1Ooooo00<0003oooooool0Goooo`030000oooooooo02Ooool001goool00`000?oo
ooooo`0joooo00<0003oooooool07Oooo`030000oooooooo05ooool00`000?ooooooo`1Ooooo00<0
003oooooool09oooo`007Oooo`030000oooooooo03_oool00`000?ooooooo`0Loooo00<0003ooooo
ool0Goooo`030000oooooooo05ooool00`000?ooooooo`0Woooo000Moooo00<0003oooooool0>ooo
o`030000oooooooo01coool00`000?ooooooo`31oooo00<0003oooooool09oooo`007Oooo`030000
oooooooo03coool00`000?ooooooo`0Koooo00<0003oooooool0`Oooo`030000oooooooo02Ooool0
01goool00`000?ooooooo`0loooo00<0003oooooool06oooo`030000oooooooo0<7oool00`000?oo
ooooo`0Woooo000Moooo00<0003oooooool0??ooo`030000oooooooo01_oool00`000?ooooooo`31
oooo00<0003oooooool09oooo`007Oooo`030000oooooooo03goool00`000?ooooooo`0Joooo00<0
003oooooool0`Oooo`030000oooooooo02Ooool001goool00`000?ooooooo`0moooo00<0003ooooo
ool06_ooo`030000oooooooo0<7oool00`000?ooooooo`0Woooo000Moooo00<0003oooooool0?_oo
o`030000oooooooo01Woool00`000?ooooooo`1Ooooo00<0003oooooool0Goooo`030000oooooooo
02Ooool001goool00`000?ooooooo`0noooo00<0003oooooool06Oooo`030000oooooooo05ooool0
0`000?ooooooo`1Ooooo00<0003oooooool09oooo`007Oooo`030000oooooooo03ooool00`000?oo
ooooo`0Hoooo00<0003oooooool0Goooo`030000oooooooo05ooool00`000?ooooooo`0Woooo000M
oooo00<0003oooooool0?oooo`030000oooooooo01Soool00`000?ooooooo`1Ooooo00<0003ooooo
ool0Goooo`030000oooooooo02Ooool001goool00`000?ooooooo`10oooo00<0003oooooool05ooo
o`030000oooooooo05ooool00`000?ooooooo`1Ooooo00<0003oooooool09oooo`007Oooo`030000
oooooooo043oool00`000?ooooooo`0Goooo00<0003oooooool0Goooo`030000oooooooo05ooool0
0`000?ooooooo`0Woooo000Moooo00<0003oooooool0@Oooo`030000oooooooo01Koool00`000?oo
ooooo`1Ooooo00<0003oooooool0Goooo`030000oooooooo02Ooool001goool00`000?ooooooo`11
oooo00<0003oooooool05_ooo`030000oooooooo05ooool00`000?ooooooo`1Ooooo00<0003ooooo
ool09oooo`007Oooo`030000oooooooo04;oool00`000?ooooooo`0Eoooo00<0003oooooool0Gooo
o`030000oooooooo05ooool00`000?ooooooo`0Woooo000Moooo00<0003oooooool0@_ooo`030000
oooooooo01Goool00`000?ooooooo`1Ooooo00<0003oooooool0Goooo`030000oooooooo02Ooool0
01goool00`000?ooooooo`13oooo00<0003oooooool05?ooo`030000oooooooo0<7oool00`000?oo
ooooo`0Woooo000Moooo00<0003oooooool0@oooo`030000oooooooo01Coool00`000?ooooooo`31
oooo00<0003oooooool09oooo`007Oooo`030000oooooooo04Coool00`000?ooooooo`0Coooo00<0
003oooooool0`Oooo`030000oooooooo02Ooool001goool00`000?ooooooo`14oooo00<0003ooooo
ool04oooo`030000oooooooo0<7oool00`000?ooooooo`0Woooo000Moooo00<0003oooooool0AOoo
o`030000oooooooo01;oool00`000?ooooooo`31oooo00<0003oooooool09oooo`007Oooo`030000
oooooooo04Goool00`000?ooooooo`0Boooo00<0003oooooool0Goooo`030000oooooooo05ooool0
0`000?ooooooo`0Woooo000Moooo00<0003oooooool0A_ooo`030000oooooooo017oool00`000?oo
ooooo`1Ooooo00<0003oooooool0Goooo`030000oooooooo02Ooool001goool00`000?ooooooo`16
oooo00<0003oooooool04Oooo`030000oooooooo05ooool00`000?ooooooo`1Ooooo00<0003ooooo
ool09oooo`007Oooo`030000oooooooo04Ooool00`000?ooooooo`0@oooo00<0003oooooool0Gooo
o`030000oooooooo05ooool00`000?ooooooo`0Woooo000Moooo00<0003oooooool0Aoooo`030000
oooooooo013oool00`000?ooooooo`1Ooooo00<0003oooooool0Goooo`030000oooooooo02Ooool0
01goool00`000?ooooooo`18oooo00<0003oooooool03oooo`030000oooooooo05ooool00`000?oo
ooooo`1Ooooo00<0003oooooool09oooo`007Oooo`030000oooooooo04Soool00`000?ooooooo`0?
oooo00<0003oooooool0Goooo`030000oooooooo05ooool00`000?ooooooo`0Woooo000Moooo00<0
003oooooool0BOooo`030000oooooooo00koool00`000?ooooooo`1Ooooo00<0003oooooool0Gooo
o`030000oooooooo02Ooool001goool00`000?ooooooo`19oooo00<0003oooooool03_ooo`030000
oooooooo05ooool00`000?ooooooo`1Ooooo00<0003oooooool09oooo`007Oooo`030000oooooooo
04[oool00`000?ooooooo`0=oooo00<0003oooooool0Goooo`030000oooooooo05ooool00`000?oo
ooooo`0Woooo000Moooo00<0003oooooool0B_ooo`030000oooooooo00goool00`000?ooooooo`31
oooo00<0003oooooool09oooo`007Oooo`030000oooooooo04_oool00`000?ooooooo`0<oooo00<0
003oooooool0`Oooo`030000oooooooo02Ooool001goool00`000?ooooooo`1;oooo00<0003ooooo
ool03?ooo`030000oooooooo0<7oool00`000?ooooooo`0Woooo000Moooo00<0003oooooool0C?oo
o`030000oooooooo00_oool00`000?ooooooo`31oooo00<0003oooooool09oooo`007Oooo`030000
oooooooo04coool00`000?ooooooo`0;oooo00<0003oooooool0`Oooo`030000oooooooo02Ooool0
01goool00`000?ooooooo`1=oooo00<0003oooooool02_ooo`030000oooooooo05ooool00`000?oo
ooooo`1Ooooo00<0003oooooool09oooo`007Oooo`030000oooooooo04goool00`000?ooooooo`0:
oooo00<0003oooooool0Goooo`030000oooooooo05ooool00`000?ooooooo`0Woooo000Moooo00<0
003oooooool0C_ooo`030000oooooooo00Woool00`000?ooooooo`1Ooooo00<0003oooooool0Gooo
o`030000oooooooo02Ooool001goool00`000?ooooooo`1>oooo00<0003oooooool02Oooo`030000
oooooooo05ooool00`000?ooooooo`1Ooooo00<0003oooooool09oooo`007Oooo`030000oooooooo
04ooool00`000?ooooooo`08oooo00<0003oooooool0Goooo`030000oooooooo05ooool00`000?oo
ooooo`0Woooo000Moooo00<0003oooooool0Coooo`030000oooooooo00Soool00`000?ooooooo`1O
oooo00<0003oooooool0Goooo`030000oooooooo00goool3000000?oool0000000001?ooo`030000
oooooooo00goool001goool00`000?ooooooo`1@oooo00<0003oooooool01oooo`030000oooooooo
05ooool00`000?ooooooo`1Ooooo00<0003oooooool03?ooo`040000oooooooooooo0P0000Goool0
0`000?ooooooo`0=oooo000Moooo00<0003oooooool0D?ooo`030000oooooooo00Ooool00`000?oo
ooooo`1Ooooo00<0003oooooool0Goooo`030000oooooooo00coool00`000?ooooooo`02oooo00<0
003oooooool00oooo`030000oooooooo00goool001goool00`000?ooooooo`1Aoooo00<0003ooooo
ool01_ooo`030000oooooooo05ooool00`000?ooooooo`1Ooooo00<0003oooooool03Oooo`D00006
oooo00<0003oooooool03?ooo`007Oooo`030000oooooooo057oool00`000?ooooooo`06oooo00<0
003oooooool0Goooo`030000oooooooo05ooool00`000?ooooooo`0<oooo00<0003oooooool00_oo
o`030000oooooooo00Coool00`000?ooooooo`0<oooo000Moooo00<0003oooooool0D_ooo`030000
oooooooo00Goool00`000?ooooooo`31oooo00<0003oooooool03Oooo`@00008oooo00<0003ooooo
ool02oooo`007Oooo`030000oooooooo05;oool00`000?ooooooo`05oooo00<0003oooooool0`Ooo
o`030000oooooooo01Coool00`000?ooooooo`02oooo00<0003oooooool02oooo`007Oooo`030000
oooooooo05?oool00`000?ooooooo`04oooo00<0003oooooool0`Oooo`030000oooooooo01Coool6
00003Oooo`007Oooo`030000oooooooo05?oool00`000?ooooooo`04oooo00<0003oooooool0`Ooo
o`030000oooooooo02Ooool001goool00`000?ooooooo`1Doooo00<0003oooooool00oooo`030000
oooooooo0<7oool00`000?ooooooo`0Woooo000Moooo00<0003oooooool0E?ooo`030000oooooooo
00?oool00`000?ooooooo`31oooo00<0003oooooool09oooo`007Oooo`030000oooooooo05Goool0
0`000?ooooooo`02oooo00<0003oooooool0Goooo`030000oooooooo05ooool00`000?ooooooo`0W
oooo000Moooo00<0003oooooool0EOooo`030000oooooooo00;oool00`000?ooooooo`1Ooooo00<0
003oooooool0Goooo`030000oooooooo02Ooool001goool00`000?ooooooo`1Foooo00D0003ooooo
ooooool00000HOooo`030000oooooooo05ooool00`000?ooooooo`0Woooo000Moooo00<0003ooooo
ool0E_ooo`050000oooooooooooo0000067oool00`000?ooooooo`1Ooooo00<0003oooooool09ooo
o`007Oooo`030000oooooooo05Ooool010000?ooooooo`00067oool00`000?ooooooo`1Ooooo00<0
003oooooool09oooo`007Oooo`030000oooooooo05Ooool010000?ooooooo`00067oool00`000?oo
ooooo`1Ooooo00<0003oooooool09oooo`007Oooo`030000oooooooo05Soool00`000?ooo`00001Q
oooo00<0003oooooool0Goooo`030000oooooooo02Ooool001goool00`000?ooooooo`1Ioooo0P00
067oool00`000?ooooooo`1Ooooo00<0003oooooool09oooo`007Oooo`030000oooooooo00;oool3
000000?oool0000000000_ooo`<0001<oooo0P00067oool00`000?ooooooo`1Ooooo00<0003ooooo
ool09oooo`007Oooo`050000oooooooooooo000000?oool200000_ooo`050000oooooooooooo0000
04coool00`000?ooooooo`1Ooooo00<0003oooooool0Goooo`030000oooooooo02Ooool001goool0
1@000?ooooooooooo`000004oooo00<0003oooooool01?ooo`030000oooooooo04[oooo50000:Ooo
o`007Oooo`030000oooooooo00;oool500001_ooo`030000oooooooo04_oool400009Oooo`030000
oooooooo09Ooool00`000?ooooooo`0Woooo000Moooo00D0003oooooooooool000001?ooo`030000
oooooooo00;oool20000C_ooo`040000oooooooooooo0P0002;oool00`000?ooooooo`2Hoooo00<0
003oooooool09oooo`007Oooo`030000oooooooo00;oool400001oooo`030000oooooooo04coool0
0`000?ooooooo`02oooo0`0001ooool00`000?ooooooo`2Hoooo00<0003oooooool09oooo`007Ooo
o`030000oooooooo00Woool01@000?ooooooooooo`00001?oooo00<0003oooooool01?ooo`<0000L
oooo00<0003oooooool0V?ooo`030000oooooooo02Ooool001goool00`000?ooooooo`0:oooo0`00
053oool00`000?ooooooo`07oooo0P0001[oool00`000?ooooooo`0foooo00<0003oooooool0Gooo
o`030000oooooooo02Ooool001goool00`000?ooooooo`1Noooo00<0003oooooool02?ooo`<0000G
oooo00<0003oooooool01Oooo`<000000oooo`0000000003oooo0`0002Goool00`000?ooooooo`1O
oooo00<0003oooooool09oooo`007Oooo`030000oooooooo05koool00`000?ooooooo`0;oooo0`00
01Coool00`000?ooooooo`04oooo00@0003oooooooooool200000oooo`050000oooooooooooo0000
02Coool00`000?ooooooo`1Ooooo00<0003oooooool09oooo`007Oooo`030000oooooooo05ooool0
0`000?ooooooo`0=oooo0P0001;oool00`000?ooooooo`04oooo00<0003oooooool00_ooo`050000
oooooooooooo000000?oool00`000?ooooooo`0Roooo00<0003oooooool0Goooo`030000oooooooo
02Ooool001goool00`000?ooooooo`1Poooo00<0003oooooool03_ooo`<0000?oooo00<0003ooooo
ool01Oooo`D00003oooo00D0003oooooooooool000009?ooo`030000oooooooo05ooool00`000?oo
ooooo`0Woooo000Moooo00<0003oooooool0H?ooo`030000oooooooo017oool300003?ooo`030000
oooooooo00Coool00`000?ooooooo`02oooo00@0003oooooooooool400009Oooo`030000oooooooo
05ooool00`000?ooooooo`0Woooo000Moooo00<0003oooooool0HOooo`030000oooooooo01?oool2
00002Oooo`030000oooooooo00Koool400001?ooo`030000oooooooo02Koool00`000?ooooooo`1O
oooo00<0003oooooool09oooo`007Oooo`030000oooooooo067oool00`000?ooooooo`0Eoooo0`00
00Koool00`000?ooooooo`0?oooo00<0003oooooool09Oooo`030000oooooooo05ooool00`000?oo
ooooo`0Woooo000Moooo00<0003oooooool0H_ooo`030000oooooooo01Ooool300000oooo`030000
oooooooo013oool300009?ooo`030000oooooooo05ooool00`000?ooooooo`0Woooo000Moooo00<0
003oooooool0H_ooo`030000oooooooo01[oool2000000?oool0003oool0>?ooo`030000oooooooo
05ooool00`000?ooooooo`0Woooo000Moooo00<0003oooooool0Hoooo`030000oooooooo01_oool3
0000V_ooo`030000oooooooo02Ooool001goool00`000?ooooooo`1Toooo00<0003oooooool07Ooo
o`<0002Goooo00<0003oooooool09oooo`007Oooo`030000oooooooo06Coool00`000?ooooooo`0P
oooo0P0009Goool00`000?ooooooo`0Woooo000Moooo00<0003oooooool0IOooo`030000oooooooo
027oool30000T_ooo`030000oooooooo02Ooool001goool00`000?ooooooo`1Uoooo00<0003ooooo
ool09?ooo`<0002?oooo00<0003oooooool09oooo`007Oooo`030000oooooooo06Koool00`000?oo
ooooo`0Voooo0`0008coool00`000?ooooooo`0Woooo000Moooo00<0003oooooool0Ioooo`030000
oooooooo02Soool20000:?ooo`030000oooooooo05ooool00`000?ooooooo`0Woooo000Moooo00<0
003oooooool0Ioooo`030000oooooooo02[oool300009Oooo`030000oooooooo05ooool00`000?oo
ooooo`0Woooo000Moooo00<0003oooooool0J?ooo`030000oooooooo02coool300008_ooo`030000
oooooooo05ooool00`000?ooooooo`0Woooo000Moooo00<0003oooooool0JOooo`030000oooooooo
02koool200008?ooo`030000oooooooo05ooool00`000?ooooooo`0Woooo000Moooo00<0003ooooo
ool0JOooo`030000oooooooo033oool300007Oooo`030000oooooooo05ooool00`000?ooooooo`0W
oooo000Moooo00<0003oooooool0J_ooo`030000oooooooo03;oool300006_ooo`030000oooooooo
05ooool00`000?ooooooo`0Woooo000Moooo00<0003oooooool0J_ooo`030000oooooooo03Goool2
00006?ooo`030000oooooooo05ooool00`000?ooooooo`0Woooo000Moooo00<0003oooooool0Jooo
o`030000oooooooo03Koool300005Oooo`030000oooooooo05ooool00`000?ooooooo`0Woooo000M
oooo00<0003oooooool0K?ooo`030000oooooooo03Soool300004_ooo`030000oooooooo05ooool0
0`000?ooooooo`0Woooo000Moooo00<0003oooooool0K?ooo`030000oooooooo03_oool20000L_oo
o`030000oooooooo02Ooool001goool00`000?ooooooo`1]oooo00<0003oooooool0??ooo`<0001_
oooo00<0003oooooool09oooo`007Oooo`030000oooooooo06koool00`000?ooooooo`0noooo0`00
06coool00`000?ooooooo`0Woooo000Moooo00<0003oooooool0K_ooo`030000oooooooo047oool2
0000J_ooo`030000oooooooo02Ooool001goool00`000?ooooooo`1_oooo00<0003oooooool0@_oo
o`<0001Woooo00<0003oooooool07?ooo`030000oooooooo00Soool001goool00`000?ooooooo`1`
oooo00<0003oooooool0A?ooo`<0001Toooo00<0003oooooool06oooo`030000oooooooo00Woool0
01goool00`000?ooooooo`1`oooo00<0003oooooool0Aoooo`<0001Qoooo00<0003oooooool06ooo
o`030000oooooooo00Woool001goool00`000?ooooooo`1aoooo00<0003oooooool0B?ooo`<0001O
oooo00<0003oooooool06_ooo`030000oooooooo00[oool001goool00`000?ooooooo`1aoooo00<0
003oooooool0B?ooo`030000oooooooo00<0001Loooo00<0003oooooool06_ooo`030000oooooooo
00[oool001goool00`000?ooooooo`1boooo00<0003oooooool0Aoooo`030000oooooooo00?oool3
0000FOooo`030000oooooooo01Woool00`000?ooooooo`0;oooo000Moooo00<0003oooooool0Looo
o`030000oooooooo04Koool00`000?ooooooo`06oooo0P0005Ooool00`000?ooooooo`0Hoooo00<0
003oooooool03?ooo`007Oooo`030000oooooooo07?oool00`000?ooooooo`16oooo00<0003ooooo
ool02?ooo`<0001Doooo00<0003oooooool06?ooo`030000oooooooo00coool001goool00`000?oo
ooooo`1doooo00<0003oooooool0AOooo`030000oooooooo00_oool30000DOooo`030000oooooooo
01Ooool00`000?ooooooo`0=oooo000Moooo00<0003oooooool0MOooo`030000oooooooo04Coool0
0`000?ooooooo`0>oooo0P0004ooool00`000?ooooooo`0Goooo00<0003oooooool03Oooo`007Ooo
o`030000oooooooo07Koool00`000?ooooooo`13oooo00<0003oooooool04?ooo`<0001<oooo00<0
003oooooool05_ooo`030000oooooooo00koool001goool00`000?ooooooo`1foooo00<0003ooooo
ool0@oooo`030000oooooooo01?oool30000BOooo`030000oooooooo01Goool00`000?ooooooo`0?
oooo000Moooo00<0003oooooool0Moooo`030000oooooooo05_oool20000Aoooo`030000oooooooo
01Coool00`000?ooooooo`0@oooo000Moooo00<0003oooooool0N?ooo`030000oooooooo05coool3
0000A?ooo`030000oooooooo01Coool00`000?ooooooo`0@oooo000Moooo00<0003oooooool0NOoo
o`030000oooooooo05koool30000@Oooo`030000oooooooo01?oool00`000?ooooooo`0Aoooo000M
oooo00<0003oooooool0NOooo`030000oooooooo067oool20000?oooo`030000oooooooo01;oool0
0`000?ooooooo`0Boooo000Moooo00<0003oooooool0N_ooo`030000oooooooo06;oool30000??oo
o`030000oooooooo017oool00`000?ooooooo`0Coooo000Moooo00<0003oooooool0Noooo`030000
oooooooo03koool00`000?ooooooo`0Soooo0`0003Woool00`000?ooooooo`0Aoooo00<0003ooooo
ool04oooo`007Oooo`030000oooooooo07coool00`000?ooooooo`0moooo00<0003oooooool09_oo
o`80000goooo00<0003oooooool04?ooo`030000oooooooo01Coool001goool00`000?ooooooo`1m
oooo00<0003oooooool0??ooo`030000oooooooo02Soool30000=?ooo`030000oooooooo00ooool0
0`000?ooooooo`0Eoooo000Moooo00<0003oooooool0OOooo`030000oooooooo03coool00`000?oo
ooooo`0[oooo0`00037oool00`000?ooooooo`0>oooo00<0003oooooool05_ooo`007Oooo`030000
oooooooo07koool00`000?ooooooo`0koooo00<0003oooooool0;_ooo`<0000^oooo00<0003ooooo
ool03Oooo`030000oooooooo01Ooool001goool00`000?ooooooo`1ooooo00<0003oooooool0>_oo
o`030000oooooooo037oool20000;?ooo`030000oooooooo00coool00`000?ooooooo`0Hoooo000M
oooo00<0003oooooool0P?ooo`030000oooooooo03Woool00`000?ooooooo`0coooo0`0002Woool0
0`000?ooooooo`0<oooo00<0003oooooool06?ooo`007Oooo`030000oooooooo083oool00`000?oo
ooooo`0ioooo00<0003oooooool0=_ooo`<0000Voooo00<0003oooooool02oooo`030000oooooooo
01Woool001goool00`000?ooooooo`21oooo00<0003oooooool0>?ooo`030000oooooooo03Woool2
00009?ooo`030000oooooooo00[oool00`000?ooooooo`0Joooo000Moooo00<0003oooooool0P_oo
o`030000oooooooo03Ooool00`000?ooooooo`0koooo0`00027oool00`000?ooooooo`09oooo00<0
003oooooool06oooo`007Oooo`030000oooooooo08?oool00`000?ooooooo`1goooo0`0001koool0
0`000?ooooooo`08oooo00<0003oooooool07?ooo`007Oooo`030000oooooooo04Koool20000??oo
o`030000oooooooo07Woool200007?ooo`030000oooooooo00Ooool00`000?ooooooo`0Moooo000M
oooo00<0003oooooool0B?ooo`80000koooo00<0003oooooool0N_ooo`<0000Ioooo00<0003ooooo
ool01_ooo`030000oooooooo01koool001goool00`000?ooooooo`1:oooo0`0003Woool00`000?oo
ooooo`1loooo0`0001Koool00`000?ooooooo`06oooo00<0003oooooool07_ooo`007Oooo`030000
oooooooo04goool30000=_ooo`030000oooooooo07ooool200005?ooo`030000oooooooo00Goool0
0`000?ooooooo`0Ooooo000Moooo00<0003oooooool0D?ooo`80000eoooo00<0003oooooool0P?oo
o`<0000Aoooo00<0003oooooool01?ooo`030000oooooooo023oool001goool00`000?ooooooo`1B
oooo0`0003?oool00`000?ooooooo`0aoooo00<0003oooooool0C_ooo`<0000>oooo00<0003ooooo
ool00oooo`030000oooooooo027oool001goool00`000?ooooooo`1Eoooo0`00037oool00`000?oo
ooooo`0`oooo00<0003oooooool0DOooo`80000<oooo00<0003oooooool00oooo`030000oooooooo
027oool001goool00`000?ooooooo`1Hoooo0P00033oool00`000?ooooooo`0_oooo00<0003ooooo
ool0Doooo`<00009oooo00<0003oooooool00_ooo`030000oooooooo02;oool001goool00`000?oo
ooooo`1Joooo0`0002koool00`000?ooooooo`0^oooo00<0003oooooool0E_ooo`<00006oooo00D0
003oooooooooool000009Oooo`007Oooo`030000oooooooo05goool30000;?ooo`030000oooooooo
02goool00`000?ooooooo`1Ioooo0P0000Coool010000?ooooooo`0000Koool3000000?oool00000
00001?ooo`<0000Coooo000Moooo00<0003oooooool0H?ooo`80000[oooo00<0003oooooool0;?oo
o`030000oooooooo05_oool3000000Coool0003oool00006oooo00@0003oooooooooool200001_oo
o`030000oooooooo01;oool001goool00`000?ooooooo`1Roooo0`0002Soool00`000?ooooooo`0/
oooo00<0003oooooool0G_ooo`<00007oooo00<0003oooooool00_ooo`030000oooooooo00Coool0
0`000?ooooooo`0Boooo000Moooo00<0003oooooool0IOooo`<0000Voooo00<0003oooooool0:ooo
o`030000oooooooo05ooool00`000?ooooooo`07oooo1@0000;oool600004oooo`007Oooo`030000
oooooooo06Soool200009Oooo`030000oooooooo02[oool00`000?ooooooo`1Noooo00<0003ooooo
ool01oooo`030000oooooooo00;oool01@000?ooooooooooo`000002oooo00<0003oooooool04_oo
o`007Oooo`030000oooooooo06[oool300008oooo`030000oooooooo02Woool00`000?ooooooo`1M
oooo00<0003oooooool02Oooo`@00004oooo00@0003oooooool0000Doooo000Moooo00<0003ooooo
ool0KOooo`<0000Qoooo00<0003oooooool0Qoooo`030000oooooooo01?oool00`000?ooo`00000D
oooo000Moooo00<0003oooooool0L?ooo`80000Poooo00<0003oooooool0QOooo`030000oooooooo
01Goool200005?ooo`007Oooo`030000oooooooo07;oool300007_ooo`800024oooo00<0003ooooo
ool0;?ooo`007Oooo`030000oooooooo07Goool300007Oooo`030000oooooooo083oool00`000?oo
ooooo`0]oooo000Moooo00<0003oooooool0N?ooo`80000Loooo00<0003oooooool0O_ooo`030000
oooooooo02koool001goool00`000?ooooooo`1joooo0`0001[oool00`000?ooooooo`0Roooo00<0
003oooooool0Eoooo`030000oooooooo02ooool001goool00`000?ooooooo`1moooo0`0001Soool0
0`000?ooooooo`0Qoooo00<0003oooooool0E_ooo`030000oooooooo033oool001goool00`000?oo
ooooo`20oooo0P0001Ooool00`000?ooooooo`0Poooo00<0003oooooool0EOooo`030000oooooooo
037oool001goool00`000?ooooooo`22oooo0`0001Goool200008?ooo`030000oooooooo05?oool2
0000=?ooo`007Oooo`030000oooooooo08Goool300005?ooo`030000oooooooo01goool00`000?oo
ooooo`1Boooo00<0003oooooool0=?ooo`007Oooo`030000oooooooo08Soool200004oooo`030000
oooooooo01coool00`000?ooooooo`1Aoooo00<0003oooooool0=Oooo`007Oooo`030000oooooooo
08[oool300004Oooo`030000oooooooo01_oool00`000?ooooooo`1?oooo0P0003Soool001goool0
0`000?ooooooo`2=oooo0`0000ooool00`000?ooooooo`0Joooo00<0003oooooool0C_ooo`030000
oooooooo03Soool001goool00`000?ooooooo`2@oooo0P0000koool200006_ooo`030000oooooooo
04coool20000>oooo`007Oooo`030000oooooooo09;oool300003Oooo`030000oooooooo01Ooool0
0`000?ooooooo`1;oooo00<0003oooooool0>oooo`007Oooo`030000oooooooo09Goool300002ooo
o`030000oooooooo06?oool00`000?ooooooo`0loooo000Moooo00<0003oooooool0V?ooo`80000:
oooo00<0003oooooool0H?ooo`80000ooooo000Moooo00<0003oooooool0V_ooo`<00008oooo0P00
05ooool00`000?ooooooo`0ooooo000Moooo00<0003oooooool0WOooo`<00007oooo00<0003ooooo
ool0F_ooo`800012oooo000Moooo00<0003oooooool0X?ooo`800006oooo0P0005Woool00`000?oo
ooooo`12oooo000Moooo00<0003oooooool0X_ooo`<00005oooo0P00013oool00`000?ooooooo`13
oooo00<0003oooooool0@oooo`007Oooo`030000oooooooo0:Goool300001?ooo`030000oooooooo
00goool00`000?ooooooo`11oooo0P0004Koool001goool00`000?ooooooo`2Xoooo0P0000?oool2
00003Oooo`030000oooooooo043oool00`000?ooooooo`16oooo000Moooo00<0003oooooool0Z_oo
o`<00002oooo0P0000_oool00`000?ooooooo`0noooo0P0004Woool001goool00`000?ooooooo`2]
oooo0`000003oooo0000000000Woool00`000?ooooooo`0loooo0P0004_oool001goool00`000?oo
ooooo`2`oooo0P000003oooo0000000000Ooool00`000?ooooooo`0joooo0P0004goool001goool0
0`000?ooooooo`2boooo1@0000Goool00`000?ooooooo`0hoooo0P0004ooool001goool00`000?oo
ooooo`2eoooo100000?oool00`000?ooooooo`0foooo0P00057oool001goool00`000?ooooooo`2h
oooo0`000003oooo0000oooo03Goool20000Doooo`007Oooo`030000oooooooo0;[oool30000<ooo
o`<0001Eoooo000Moooo00<0003oooooool0_Oooo`<0000]oooo0`0005Soool001goool00`000?oo
ooooo`30oooo0`0002Koool40000Foooo`007Oooo`030000oooooooo0<;oool400007oooo`@0001O
oooo000Moooo00<0003oooooool0aOooo`P0000Boooo1P0006?oool001goool00`000?ooooooo`38
oooo0P0000?ooolB0000JOooo`007Oooo`030000oooooooo0<[oool30000Noooo`007Oooo`030000
oooooooo06ooool3000000?oool0000000000_ooo`@0001Boooo0`0007Soool001goool00`000?oo
ooooo`1^oooo00@0003oooooooooool200000_ooo`030000oooooooo00;oool00`000?ooooooo`1B
oooo0P0007Koool001goool00`000?ooooooo`1^oooo00<0003oooooool00_ooo`040000oooooooo
00001?ooo`030000oooooooo05Coool30000Loooo`007Oooo`030000oooooooo06ooool500000_oo
o`030000oooooooo00;oool00`000?ooooooo`1Goooo0`00073oool001goool00`000?ooooooo`1^
oooo00<0003oooooool00_ooo`040000oooooooooooo100005goool20000K_ooo`007Oooo`030000
oooooooo06ooool400000oooo`030000oooooooo00;oool00`000?ooooooo`1Loooo0`0006_oool0
01goool00`000?ooooooo`1foooo00<0003oooooool00_ooo`030000oooooooo05ooool30000J?oo
o`007Oooo`030000oooooooo07Ooool40000IOooo`80001Voooo000Moooo00<0003oooooool0h_oo
o`<0000Ooooo0`000004oooo00000000oooo100003Woool001goool00`000?ooooooo`3Uoooo0`00
01_oool010000?ooooooooooo`800006oooo00<0003oooooool0=_ooo`007Oooo`030000oooooooo
0>Soool200006Oooo`030000oooooooo00;oool00`000?ooooooo`05oooo00<0003oooooool0=Ooo
o`007Oooo`030000oooooooo0>[oool300005oooo`D00003oooo1@0003Ooool001goool00`000?oo
ooooo`3]oooo0`0001?oool00`000?ooooooo`02oooo00@0003oooooool00004oooo00<0003ooooo
ool0=Oooo`007Oooo`030000oooooooo0?3oool200004_ooo`@00003oooo00<0003oooooool00_oo
o`030000oooooooo03Goool001goool00`000?ooooooo`3boooo0`0001Koool00`000?ooooooo`02
oooo00<0003oooooool0=Oooo`007Oooo`030000oooooooo0?Goool300005?ooo`@0000hoooo000M
oooo00<0003oooooool0n?ooo`80001>oooo000Moooo00<0003oooooool0n_ooo`<0001;oooo000M
oooo00<0003oooooool0oOooo`<00018oooo000Moooo00<0003oooooool0ooooo`7oool20000A_oo
o`007Oooo`030000oooooooo0?ooool3oooo0`0004?oool001goool00`000?ooooooo`3ooooo1_oo
o`<00010oooo000Moooo00<0003oooooool0ooooo`Woool20000?_ooo`007Oooo`030000oooooooo
0?ooool;oooo0`0003_oool001goool00`000?ooooooo`3ooooo3_ooo`<0000hoooo000Moooo00<0
003oooooool0oooooa7oool20000=_ooo`007Oooo`030000oooooooo0?oooolCoooo0`0003?oool0
01goool00`000?ooooooo`3ooooo5_ooo`<0000`oooo000Moooo00<0003oooooool0oooooaWoool2
0000;_ooo`007Oooo`030000oooooooo0?oooolKoooo0`0002_oool001goool00`000?ooooooo`3o
oooo7_ooo`<0000Xoooo000Moooo00<0003oooooool0ooooob7oool200009_ooo`007Oooo`030000
oooooooo0?oooolSoooo0`0002?oool001goool00`000?ooooooo`3ooooo9_ooo`<0000Poooo000M
oooo00<0003oooooool0ooooobWoool200007_ooo`007Oooo`030000oooooooo0?ooool[oooo0`00
01_oool001goool00`000?ooooooo`3ooooo;_ooo`<0000Hoooo000Moooo00<0003oooooool0oooo
oc7oool200005_ooo`007Oooo`030000oooooooo0?oooolcoooo0P0001Coool001goool00`000?oo
ooooo`3oooooBOooo`007Oooo`030000oooooooo0?oooom9oooo000Moooo00<0003oooooool0oooo
odWoool001goool00`000?ooooooo`3oooooBOooo`007Oooo`030000oooooooo0?oooom9oooo000M
oooo00<0003oooooool0ooooodWoool001goool00`000?ooooooo`3oooooBOooo`007Oooo`030000
oooooooo0?oooom9oooo000Moooo00<0003oooooool0ooooodWoool001goool00`000?ooooooo`3o
ooooBOooo`00\
\>"],
  ImageRangeCache->{{{0, 359}, {288.188, 0}} -> {-2.38832, -0.302874, \
0.0121053, 0.010001}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Display["\<MeanValue.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 654},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 59, 1, 35, "Input"],
Cell[1801, 54, 85, 1, 52, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[1923, 60, 327, 6, 95, "Input"],
Cell[2253, 68, 17811, 321, 300, 1819, 119, "GraphicsData", "PostScript", \
"Graphics"],
Cell[20067, 391, 130, 3, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20234, 399, 893, 15, 182, "Input"],
Cell[21130, 416, 998, 16, 161, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22165, 437, 87, 1, 35, "Input"],
Cell[22255, 440, 59, 1, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22351, 446, 53, 1, 35, "Input"],
Cell[22407, 449, 35888, 760, 300, 7608, 406, "GraphicsData", "PostScript", \
"Graphics"],
Cell[58298, 1211, 130, 3, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[58465, 1219, 75, 1, 35, "Input"],
Cell[58543, 1222, 130, 3, 35, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

